#!/usr/bin/env ruby

MERCHANT_DOMAIN = 'merchant_domain'
PAYMENT_RESULTS = {}

require 'webrick'
require_relative 'buy'
require_relative 'notify'
require_relative 'result'
require_relative 'recovery'

server = WEBrick::HTTPServer.new :Port => 8000

server.mount '/buy', Buy
server.mount '/notify', Notify
server.mount '/result', Result
server.mount '/recovery', Recovery

trap 'INT' do server.shutdown end
server.start
