class Buy < WEBrick::HTTPServlet::AbstractServlet

	# Returns the page with the BUY button
	def do_GET(request, response)
		response.status = 200
		response.content_type = 'text/html'
		payment_page = "
		<!DOCTYPE html>
		<html>
			<body>
				<form action='buy' method='POST'>
					<input type=submit value='Buy Now'>
				</form>
			</body>
		</html>
		"
		response.body = payment_page
	end

	# Responds to the action called by the BUY button
	# Manages the transaction initialization and redirects the card holder to the XPay Total Acceptance payment page
	def do_POST(request, response)
		hosted_page_url = initialize_transaction()
		response.set_redirect(WEBrick::HTTPStatus[303], hosted_page_url)
	end

	def initialize_transaction()
		require 'net/http'
		require 'rexml/document'

		payment_gateway_domain = 'https://ngwecomm-stg.nexi.it'
		transaction_init_path = '/monetaweb/payment/2/xml'
		init_uri = URI(payment_gateway_domain + transaction_init_path)

		# XPay Total Acceptance notifies the payment result to the merchant notify url
		# The merchant response, when the notify url is called, should contain the url where the card holder will be redirected to view the payment result (e.g. Payment Ok, Payment Failed)
		merchant_url_to_notify_payment_result = "#{MERCHANT_DOMAIN}/notify"
		# If the notify url is not reachable, XPay Total Acceptance will redirect the card holder to the merchant recovery url
		merchant_recovery_url = "#{MERCHANT_DOMAIN}/recovery"

		parameters = {
			id: '99999999', # Terminal Id
			password: '99999999',
			tenantId: '10',
			operationType: 'initialize',
			amount: '1.00',
			currencyCode: '978', #EUR
			laguage: 'ITA',
			responseToMerchantUrl: merchant_url_to_notify_payment_result,
			recoveryUrl: merchant_recovery_url,
			merchantOrderId: 'TRCK0001',
			cardHolderName: 'Tom Smith',
			cardHolderEmail: 'tom.smith@test.com',
			description: 'Description',
			customField: 'Custom Field'
		}

		response = Net::HTTP.post_form(init_uri, parameters)
		raise "Payment initialization failed: #{response.body}" unless response.code == "200"

		xmlResponse = REXML::Document.new(response.body)
		payment_id = xmlResponse.root.elements["paymentid"].text
		hosted_page_url = xmlResponse.root.elements["hostedpageurl"].text

		"#{hosted_page_url}?PaymentID=#{payment_id}"
	end
end
