package sample.utils;

import static java.net.URLEncoder.encode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;

public class SampleHttpClient {

	public static String sendPost(String InitUrl, Map<String, String> parameters) throws Exception {
		URL url = new URL(InitUrl);

		String data = "";
		for (String key : parameters.keySet()) {
			if (!data.isEmpty()) {
				data += "&";
			}

			String encodeKey = encode(key, "UTF-8");
			String parameter = parameters.get(key);
			String encodeParameter = encode(parameter, "UTF-8");
			data += encodeKey + "=" + encodeParameter;
		}

		HttpURLConnection conn = (HttpURLConnection) url.openConnection();
		conn.setRequestMethod("POST");
		conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
		conn.setDoInput(true);
		conn.setDoOutput(true);
		conn.setUseCaches(false);

		OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
		wr.write(data);
		wr.flush();

		InputStream inputStream = conn.getInputStream();
		String outputData = readAll(inputStream);

		return outputData;
	}

	private static String readAll(InputStream inputStream) throws IOException {
		BufferedReader dis = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
		StringBuffer buf = new StringBuffer();
		while (true) {
			String s = dis.readLine();
			if (s == null) {
				break;
			}
			buf.append(s).append("\n");
		}
		return buf.toString();
	}

}
