package sample.utils;

public class InitResponse {

	private final String responseAsXml;

	public InitResponse(String xmlResponse) {
		this.responseAsXml = xmlResponse;

	}

	public boolean containsErrors() {
		return responseAsXml.startsWith("<error>");
	}

	public String getCardholderRedirectUrl() {
		String url = getFirstElementByTagName("hostedpageurl");
		String paymentId = getFirstElementByTagName("paymentid");
		url += "?paymentid=" + paymentId;
		return url;
	}

	public String getSecuritytoken() {
		return getFirstElementByTagName("securitytoken");
	}

	private String getFirstElementByTagName(String tagName) {
		String tagOpen = "<" + tagName + ">";
		String tagClose = "</" + tagName + ">";
		return substringBetween(responseAsXml, tagOpen, tagClose);
	}

	private String substringBetween(String string, String begin, String end) {
		int tagOpenIndex = string.indexOf(begin) + begin.length();
		int tagCloseIndex = string.indexOf(end);
		return string.substring(tagOpenIndex, tagCloseIndex);
	}

	public static void main(String[] args) {
		String sample = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + "<paymentid>429016931113940179</paymentid>\n"
				+ "<paymentpageurl>http://127.0.0.1:8080/phoenix-0.0/phoenixServlet/hosted/page</paymentpageurl>";

		InitResponse xmlUtil = new InitResponse(sample);
		String paymentid = xmlUtil.getFirstElementByTagName("paymentid");
		System.out.println(paymentid);
		String paymentpageurl = xmlUtil.getFirstElementByTagName("paymentpageurl");
		System.out.println(paymentpageurl);

		String securitytoken = xmlUtil.getFirstElementByTagName("securitytoken");
		System.out.println(securitytoken);
	}
}
