package sample;

import sample.utils.SampleHttpClient;
import sample.utils.InitResponse;

public class Buy {

	public String performInit(InitData initData) throws Exception {
		MerchantData dataToSend = new MerchantData();

		dataToSend.id = initData.Id;
		dataToSend.password = initData.password;
		dataToSend.tenantId = initData.tenantId;
		dataToSend.operationType = initData.operationType;
		dataToSend.amount = initData.amount;
		dataToSend.currencyCode = initData.currencyCode;
		dataToSend.language = initData.language;
		dataToSend.responseToMerchantUrl = initData.responseToMerchantUrl;
		dataToSend.merchantOrderId = initData.merchantOrderId;
		dataToSend.description = initData.description;
		dataToSend.customField = initData.customField;
		dataToSend.recoveryUrl = initData.recoveryUrl;
		dataToSend.cardHolderName = initData.cardHolderName;
		dataToSend.cardHolderEmail = initData.cardHolderEmail;

		String xmlResponse = SampleHttpClient.sendPost(initData.initURL, dataToSend.getFormattedParameters());
		System.out.println("xmlResponse:\n" + xmlResponse);

		InitResponse initResponse = new InitResponse(xmlResponse);
		if (!initResponse.containsErrors()) {
			// il security token è una misura di sicurezza ulteriore:
			// è un codice casuale che verrà spedito anche nelle fasi successive
			// del
			// pagamento per assicurare la genuinità della risposta.
			@SuppressWarnings("unused")
			String securityToken = initResponse.getSecuritytoken();

			String paymentPageUrl = initResponse.getCardholderRedirectUrl();

			// la GUI poi farà una redirect al paymentPageUrl

			return paymentPageUrl;
		} else
			throw new Exception("Payment initialization failure");
	}

}
